<div class="panel panel-default">
    <div class="panel-body">
        <form class="form" id="register-form" action="<?= site_url('/register/submit') ?>" method="post">
            <div class="form-group div-bor">
                <i class="icon-user"></i>
                <input class="form-control" data-required="true" title="用户名" placeholder="USERNAME" name="username" type="text" maxlength="20" value=""/>
            </div>

            <div class="form-group div-bor">
                <i class="icon-key"></i>
                <input class="form-control" data-required="true" title="密码" placeholder="PASSWORD" name="password" type="password" maxlength="32" value=""/>
            </div>

            <div class="form-group div-bor">
                <i class="icon-key"></i>
                <input class="form-control" data-required="true" title="重复密码" placeholder="REPASSWORD" name="repassword" type="password" maxlength="32" value=""/>
            </div>

            <div class="form-inline form-group" id="selectCity">
                <select class="form-control" data-type="1" name="province">
                    <option>请选择所在地区</option>
                    <?php foreach ($provinces as $p): ?>
                        <option value="<?= $p['id'] ?>"><?= $p['name'] ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group div-bor">
                <input class="btn btn-primary btn-lg btn-block" type="submit" value="注 册"/>
            </div>
        </form>
    </div>
</div>

<script type="text/javascript">
    $(function () {
        $('#register-form').formValidator({
            before: function () {
                var city=$('select[name=city]').val();
                if (!city) {
                    show_error('未选择所在地区。');
                    return false;
                }
            },
            sending: {
                type: 'ajax',
                success: function (data) {
                    var e = $.parseJSON(data);
                    if (e.error) {
                        show_error({'message': e.error, 'color': 'danger'});
                    } else {
                        show_error(e.success);
                        window.location.href = "<?=site_url('main');?>";
                    }
                },
                error: function () {
                    show_error("提交失败！");
                }
            }
        });

        $('#selectCity').on('change', 'select', function () {
            var id = $(this).val();
            $(this).nextAll().remove();
            var pid = $(this).prev('select').val();
            if (id==pid) return;
            $.get('<?=site_url('register/city')?>/' + id, function (data) {
                if (data) {
                    var cities = $.parseJSON(data);
                    if (cities.length < 1) return;
                    $('select[name=city]').attr('name','');
                    var s = $('<select>', {
                        'name': 'city',
                        'class': 'form-control'
                    }).append($('<option value="' + id + '">').html('请选择'));
                    $.each(cities, function (key, city) {
                        s.append($('<option>', {'value': city.id}).html(city.name));
                    });
                    $('#selectCity').append(s);
                }
            })
        })
    });
</script>