<form class="form-horizontal" role="form">
    <div class="panel panel-default leftContent">
        <div class="panel-heading">
            <div class="row">
                <div class="col-md-6">
                    <h5><?= $user['name'] ?></h5>
                </div>
                <div class="col-md-6 text-right">
                    <button class="btn btn-primary" type="submit" title="保存">
                        <i class="fa fa-save"></i>
                    </button>
                </div>
            </div>
        </div>
        <div class="panel-body">
            <div class="form-group">
                <label for="inputEmail3" class="col-sm-2 control-label">等级</label>

                <div class="col-sm-6">
                    <h6>
                        <?php
                        switch ($user['level']) {
                            case '9':
                                echo '管理员';
                                break;
                            case '7':
                                echo '教师';
                                break;
                            default:
                                echo '普通用户';
                                break;
                        }
                        ?>
                    </h6>
                </div>
            </div>
            <div class="form-group">
                <label for="" class="col-sm-2 control-label">头像</label>

                <div class="col-sm-6">
                    <div class="well">上传头像文件的最大尺寸为100KB。后缀名为JPG、PNG、JPEG、BMP</div>
                    <input type="file" class="file-loading" name="imageUpload" id="avatarUpload">
                </div>
            </div>
            <div class="form-group">
                <label for="email" class="col-sm-2 control-label">邮箱</label>

                <div class="col-sm-6">
                    <input type="email" class="form-control" name="email" value="<?= $user['email'] ?>" placeholder="Email">
                </div>
            </div>
            <div class="form-group form-inline">
                <label class="col-sm-2 control-label">地区</label>

                <div class="col-sm-6" id="selectCity">
                    <select class="form-control">
                        <?php foreach ($province as $p): ?>
                            <option value="<?= $p['id'] ?>" <?= substr($user['city'], 0, 2) == $p['id'] ? 'selected' : '' ?>><?= $p['name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                    <select class="form-control">
                        <?php foreach ($city as $p): ?>
                            <option value="<?= $p['id'] ?>" <?= substr($user['city'], 0, 4) == $p['id'] ? 'selected' : '' ?>><?= $p['name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                    <select class="form-control">
                        <?php foreach ($district as $p): ?>
                            <option value="<?= $p['id'] ?>" <?= $user['city'] == $p['id'] ? 'selected' : '' ?>><?= $p['name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
        </div>
    </div>
</form>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/fileinput.min.css"/>
<script src="<?= THEMEPATH ?>/js/fileinput.min.js"></script>
<script src="<?= THEMEPATH ?>/js/fileinput_locale_zh.js"></script>

<script type="text/javascript">
    $(function () {
        //上传头像
        $('#avatarUpload').fileinput({
            'language': 'zh', //设置语言
            'uploadUrl': "<?= site_url('/user/avatar') ?>",
            'maxFileSize': 100,
            showCaption: true,
            uploadClass: 'btn btn-success',
            elErrorContainer: '#kv-avatar-errors',
            defaultPreviewContent: '<img src="<?= THEMEPATH?>/images/avatar/<?=isset($user['avatar'])&& $user['avatar']!='' ?  $user['avatar'] : 'default.jpg' ?>" alt="头像" style="width:150px">',
            allowedFileExtensions: ["jpg", "png", "bmp", 'jpeg']
        });

        $('#avatarUpload').on('fileuploaded', function (event, data) {
            var file = data.response;
            var image_url = ' <?=THEMEPATH?>/images/avatar/' + file.profile['file_name'];
            $('#userAvatar').attr('src', image_url);
            show_error('头像保存成功。');
        });

        $('#selectCity').on('change', 'select', function () {
            var id = $(this).val();
            $(this).nextAll().remove();
            $.get('<?=site_url('register/city')?>/' + id, function (data) {
                if (data) {
                    var cities = $.parseJSON(data);
                    if (cities.length < 1) return;
                    var s = $('<select>', {'name': 'city', 'class': 'form-control'}).append($('<option>').html('请选择'));
                    $.each(cities, function (key, city) {
                        s.append($('<option>', {'value': city.id}).html(city.name));
                    });
                    $('#selectCity').append(s);
                }
            })
        })
    });
</script>