<div class="well">
    <h5>
        <i class="fa fa-warning"></i>
        <strong class="">开考后在进场时间内进入考场，超过进场时间，将不能参加考试！！！</strong>
        <small>状态为练习的考场，可以不限进入，只记录最后一次得分、试卷。</small>
    </h5>
</div>

<div class="box box-primary" id="examDiv">
  <div class="box-header">
    <h3 class="box-title">考试</h3>
  </div>
  <div class="box-body">

  </div>
</div>

<div class="box box-primary" id="testDiv">
  <div class="box-header">
    <h3 class="box-title">练习</h3>
  </div>
  <div class="box-body">

  </div>
</div>

  <?php foreach ($rooms as $room) : ?>
    <div class="col-md-2 col-sm-3 testList hidden"
          data-stat="<?= $room['stat'] ?>"
          data-time="<?= $room['time'] ?>"
          data-end="<?= $room['start'] ?>"
          data-id="<?= $room['id'] ?>"
          >
          <div class="small-box bg-aqua" >
            <div class="inner">
              <h4>
                <a href="#" class="small-box-footer takeTest">
                  <?= $room['name'] ?>
                </a>
              </h4>
              <p>
                开考：<?= $room['time'] ?>
              <br />
              进场：<?= $room['start'] ? $room['start'] . ' 分钟' : "不限" ?>
              <br / >
              得分：<?= (isset($room['score'])&& $room['score'] != null) ? $room['score'] : "未参加考试"?>
            </p>
            </div>
            <div class="icon">
              <i class="fa fa-bag"></i>
            </div>
            <?php if ($user['level'] >= 7) { ?>
                    <a href="#" class="small-box-footer statTest" type="button">
                        <i class="fa fa-bar-chart"></i>
                        得分统计
                    </a>
                <?php } else {
            if ($room['score'] == null || $room['stat'] == 1){ ?>
            <a href="#" class="small-box-footer takeTest">进入考场 <i class="fa fa-arrow-circle-right"></i></a>
          <?php } else if ($room['score'] != null) { ?>
              <a href="#" class="small-box-footer viewTest" data-exam-id="<?= $room['exam_page_id'] ?>" type="button">
                  <i class="fa fa-eye"></i>
                  查看试卷
              </a>
          <?php } ?>
        <?php } ?>
          </div>
          </div>
<?php endforeach; ?>

<?php if ($user['level'] < 7) { ?>
    <div class="panel panel-default">
        <div class="panel-body">
            <div id="score" style="height: 250px;"></div>
        </div>
    </div>
<?php } ?>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/dataTables.bootstrap.min.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.dataTables.min.js"></script>
<script src="<?= THEMEPATH ?>/js/dataTables.bootstrap.min.js"></script>
<script src="<?= THEMEPATH ?>/js/echarts.min.js"></script>

<script type="text/javascript">
    $(function () {
        $('#listTable').DataTable({
            language: {
                'url': '<?=THEMEPATH?>/js/dataTables.zh-CN.json'
            },
            "processing": true,
            'searching': false,
            'order': [[1, 'desc']]
        });

        $(".testList").each(function() {
          if ($(this).data("stat")==1)
          $(this).appendTo($("#testDiv").children(".box-body")).removeClass("hidden");
          else
          $(this).appendTo($("#examDiv").children(".box-body")).removeClass("hidden");
        })
        <?php if ($user['level']<7) {?>
        var option = {
            title: {
                text: '得分统计'
            },
            tooltip: {
                trigger: 'axis'
            },
            xAxis: {
                data: <?=$time?>
            },
            yAxis: {
                type: 'value'
            },
            series: [
                {
                    name: '分数',
                    type: 'line',
                    data:<?=$score?>
                }
            ]
        };

        var myChart = echarts.init(document.getElementById('score'));
        myChart.setOption(option);

        $('.takeTest').click(function () {
            var start = $(this).parents('.testList').data('time');
            var end = $(this).parents('.testList').data('end');
            start = new Date(start.replace(/-/g, "/"));
            var time = new Date();
            var pass = (time - start) / 60000;

            if (end != 0 && pass > end) {
                alert('已开考 ' + pass.toFixed(0) + ' 分钟，超过进场时间' + end + '分钟限制，已经不能参加考试。');
                return false;
            } else {
                var id = $(this).parents('.testList').data('id');
                var opt = 'top=0, left=0, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no, status=no';
                var tmp = window.open("<?=site_url('main/take')?>/" + id, "_blank", opt);
                tmp.moveTo(0, 1);
                tmp.resizeTo(screen.availWidth, screen.availHeight);
                tmp.focus();
            }
        });

        $('.viewTest').click(function () {
            var id = $(this).data('exam-id');
            var opt = 'top=0, left=0, toolbar=no, menubar=no, scrollbars=yes, resizable=no,location=no, status=no';
            var tmp = window.open("<?=site_url('test/view')?>/" + id, "_blank", opt);
            tmp.moveTo(0, 1);
            tmp.resizeTo(screen.availWidth, screen.availHeight);
            tmp.focus();
        });
        <?php } else {?>
        $('.statTest').click(function () {
            var id = $(this).parents('.testList').data('id');
            $('.main-content').load('<?=site_url("admin/stat")?>/'+id);
        });
        <?php } ?>
    });
</script>
