<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/bootstrap.min.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/front.css"/>

<div class="error-message">
    <div class="panel panel-warning">
        <div class="panel-heading">
            <h4>A PHP Error was encountered</h4>
        </div>
        <div class="panel-body">

            <p>Severity: <?php echo $severity; ?></p>

            <p>Message: <?php echo $message; ?></p>

            <p>Filename: <?php echo $filepath; ?></p>

            <p>Line Number: <?php echo $line; ?></p>
            <?php if (defined('SHOW_DEBUG_BACKTRACE') && SHOW_DEBUG_BACKTRACE === TRUE): ?>
                <p>Backtrace:</p>
                <?php foreach (debug_backtrace() as $error): ?>
                    <?php if (isset($error['file']) && strpos($error['file'], realpath(BASEPATH)) !== 0): ?>
                        <p style="margin-left:10px">
                            File: <?php echo $error['file'] ?><br/>
                            Line: <?php echo $error['line'] ?><br/>
                            Function: <?php echo $error['function'] ?>
                        </p>
                    <?php endif ?>
                <?php endforeach ?>
            <?php endif ?>

        </div>
    </div>
</div>
