<div class="row">
    <div class="col-sm-6">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h5>用户管理</h5>
            </div>
            <div class="container-fluid">
                <table class="table" id="usersTable">
                    <thead>
                    <tr>
                        <th>id</th>
                        <th>名称</th>
                        <th>级别</th>
                        <th>地区</th>
                        <th></th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-6">
        <form class="form-horizontal" method="post" action="<?= site_url('admin/users/edit') ?>" id="userForm">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-md-8">
                            <h5><span id="edit">新增</span>用户
                            <small>新建用户请点击右侧新建按钮</small>
                            </h5>
                        </div>
                        <div class="col-md-4 text-right">
                            <div class="btn-group">
                                <button class="btn btn-primary" type="submit" title="保存">
                                    <i class="fa fa-save"></i>
                                </button>
                                <button class="btn btn-default" id="importUser" type="button" title="导入">
                                    <i class="fa fa-upload"></i>
                                </button>
                                <button class="btn btn-default" id="newUser" type="button" title="新建">
                                    <i class="fa fa-user-plus"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="panel-body">
                    <input type="hidden" name="id" value="" />
                    <div class="form-group">
                        <label class="col-sm-2 control-label">名称</label>
                        <div class="col-sm-8">
                            <input type="text" class="form-control" data-required="true" name="name" value="" placeholder="Username">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label">密码</label>
                        <div class="col-sm-8">
                            <input type="text" class="form-control" name="password" placeholder="Password 留空默认为123">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label">邮箱</label>
                        <div class="col-sm-8">
                            <input type="email" class="form-control" name="email" value="" placeholder="EMail 可选">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label">级别</label>
                        <div class="col-sm-8">
                            <select class="form-control" name="level">
                                <option value="1">学员</option>
                                <option value="7">教师</option>
                                <option value="9">管理员</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">地区</label>
                        <input type="hidden" name="city" value=""/>

                        <div class="col-sm-8">
                            <div class="div-bor">
                                <i class="fa fa-caret-down"></i>
                                <input type="text" class="form-control" data-required="true" name="cityName" value="" readonly/>
                            </div>
                            <div class="relative" style="display: none;">
                                <div class="jtree" id="selectCity">
                                    <div class="absolute" id="0">
                                        <li >
                                            <i class="fa fa-square"></i>
                                            所有地区
                                        </li>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/dataTables.bootstrap.min.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/jquery.jtree.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.jtree.js"></script>
<script src="<?= THEMEPATH ?>/js/jquery.dataTables.min.js"></script>
<script src="<?= THEMEPATH ?>/js/dataTables.bootstrap.min.js"></script>
<script src="<?= THEMEPATH ?>/js/validator.js"></script>

<script type="text/javascript">
    $(function () {
        var table = $('#usersTable').DataTable({
            language: {
                'url': '<?=THEMEPATH?>/js/dataTables.zh-CN.json'
            },
            "processing": true,
            "serverSide": true,
            'searching': true,
            "ajax": "<?= site_url("/admin/users/table") ?>",
            "columns": [
                {"data": "id"},
                {"data": "name"},
                {"data": "level"},
                {"data": "city_name"},
                {"data": "action"}
            ],
            'columnDefs': [{
                'orderable': false,//禁用排序
                'targets': [4]   //指定的列
            }],
            "createdRow": function (row, data, index) {
                var title = '学员';
                switch (data.level) {
                    case '9' :
                        title = '管理员';
                        break;
                    case '7':
                        title = '教师';
                        break;
                    default :
                        break;
                }
                $('td', row).eq(2).html(title);

            }
        });

        var node = <?=json_encode($cities, JSON_UNESCAPED_UNICODE)?>;
        $('#selectCity').jtree({
            data: node,
            height: 200,
            button: false,
            select: true,
            close: false,
            selectID: '<?=isset($city)?$city['id']:''?>',
            nodeAction: function (id, text) {
                $('input[name=city]').val(id);
                $('input[name=cityName]').val(text);
            }
        });

        $('input[name=cityName]').focus(function () {
            $('#selectCity').parent('div').slideDown();
        });

        $('input[name=cityName]').blur(function () {
            $('#selectCity').parent('div').slideUp();
        });

        $('#newUser').click(function () {
            $('#edit').text('新增');
            $('input[name=password]').attr('placeholder','留空默认为123');
            $('input').val('');
            $('select[name=level]').val(1);
        });

        $('#usersTable').on('click', '.editUser', function () {
            var id = $(this).parents('tr').attr('id');
            $.get('<?=site_url("admin/users/get")?>/'+id, function (data) {
                var user= $.parseJSON(data)[0];
                $('#edit').text('编辑');
                $('input[name=id]').val(user.id);
                $('input[name=name]').val(user.name);
                $('input[name=password]').attr('placeholder','留空不修改密码');
                $('select[name=level]').val(user.level);
                $('input[name=city]').val(user.city);
                $('input[name=cityName]').val(user.city_name);
            });
        });

        $('#usersTable').on('click', '.deleteUser', function () {
            var id = $(this).parents('tr').attr('id');
            BootstrapDialog.confirm({
                title: "删除用户",
                message: "确认删除此用户？",
                type: BootstrapDialog.TYPE_WARNING,
                btnCancelLabel: '取消',
                btnOKLabel: '删除!',
                callback: function (result) {
                    if (result) {
                        $.post('<?=site_url("admin/users/delete")?>',{'id':id}, function (data) {

                        });
                    }
                }
            });

        });

        $('#userForm').formValidator({
            sending: {
                type: 'ajax',
                success: function (data) {
                    var e = $.parseJSON(data);
                    if (e.error) {
                        show_error({'message': e.error, 'color': 'danger'});
                    } else {
                        show_error(e.success);
                        $('input').val('');
                        table.ajax.reload(null, false);
                    }
                },
                error: function () {
                    show_error("提交失败！");
                }
            }
        });
    });
</script>
