<div class="row">
    <div class="col-md-6">
        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-md-6">
                        <h5>题型管理<small>请尽量不要修改此表。</small></h5>
                    </div>
                    <div class="col-md-6 text-right">
                        <div class=" btn-group">

                        </div>
                    </div>
                </div>

            </div>

            <div class="container-fluid card">
                <table class="table" id="typeTable">
                    <thead>
                    <tr>
                        <th width="20px">ID</th>
                        <th>题型</th>
                        <th>类型</th>
                        <th width="80px">操作</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <form class="form-horizontal" id="typeForm" method="post" action="<?= site_url('admin/type/edit') ?>">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-md-6">
                            <h5>编辑题型</h5>
                        </div>
                        <div class="col-md-6 text-right">
                            <div class=" btn-group">
                                <button class="btn btn-primary" type="submit" title="保存题型">
                                    <i class="fa fa-save"></i>
                                </button>

                                <button class="btn btn-info" type="button" id="createType" title="新建">
                                    <i class="fa fa-plus"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="panel-body">
                    <div class="form-group">
                        <label for="email" class="col-sm-2 control-label">名称</label>

                        <div class="col-sm-10">
                            <input type="text" data-required="true" class="form-control" name="name" value="" />
                            <input type="hidden" class="form-control" name="id" value="" />
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="email" class="col-sm-2 control-label">类型</label>

                        <div class="col-sm-10">
                            <select name="type" class="form-control" >
                                <option value="0">客观题</option>
                                <option value="1">主观题</option>
                            </select>
                        </div>
                    </div>

                </div>
            </div>
        </form>
    </div>
</div>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/dataTables.bootstrap.min.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.dataTables.min.js"></script>
<script src="<?= THEMEPATH ?>/js/dataTables.bootstrap.min.js"></script>
<script src="<?= THEMEPATH ?>/js/validator.js"></script>

<script type="text/javascript">
    $(function () {
        var table = $('#typeTable').DataTable({
            language: {
                'url': '<?=THEMEPATH?>/js/dataTables.zh-CN.json'
            },
            "processing": true,
            "serverSide": true,
            'searching': false,
            "ajax": "<?= site_url('/admin/type/table/') ?>",
            "columns": [
                {"data": "id"},
                {"data": "name"},
                {"data": "type"},
                {"data": "action"}
            ],
            "createdRow": function (row, data) {
                switch (data.type) {
                    case '1':
                        $('td', row).eq(2).text("主观题");
                        break;
                    case '0':
                        $('td', row).eq(2).text("客观题");
                        break;
                }
                switch (data.choice) {
                    case '1':
                        $('td', row).eq(3).text("单选");
                        break;
                    case '2':
                        $('td', row).eq(3).text("多选");
                        break;
                    case '3':
                        $('td', row).eq(3).text("文本");
                        break;
                    case '4':
                        $('td', row).eq(3).text("文本框");
                        break;
                }
            }
        });


        $('#typeTable').on('click', '.editType', function () {
            var id = $(this).parents('tr').attr('id');
            $.get('<?=site_url('admin/type/select')?>/'+id,function (data) {
                var type= $.parseJSON(data);
                if (type.error) {
                    show_error(type.error);
                } else {
                    $('#typeForm input[name=id]').val(type.id);
                    $('#typeForm input[name=name]').val(type.name);
                    $('#typeForm [name=type]').val(type.type);
                    $('#typeForm [name=choice]').val(type.choice);
                }
            });
        });

        $('#typeTable').on('click', '.deleteType', function () {
            if (!confirm('确认删除此题型？')) return;
            var id = $(this).parents('tr').attr('id');
            $.get('<?=site_url('admin/type/delete')?>/'+id,function (data) {
                show_error(data);
            });
        });

        $('#typeForm').formValidator({
            sending: {
                type: 'ajax',
                success: function (data) {
                    var e= $.parseJSON(data);
                    if (e.error) {
                        show_error(e.error);
                    } else {
                        show_error(e.success);
                        $('.main-content').load('<?=site_url('admin/type')?>');
                    }
                },
                error: function () {
                    show_error('提交表单失败！');
                }
            }
        });

        $('#createType').click(function() {
            $('input').val('');
        });
    });
</script>