<div class="panel panel-default">
    <div class="panel-body">
        <div id="score" style="height: 250px;"></div>
    </div>
</div>
<div class="row">
    <div class="col-sm-8">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h5>学员得分</h5>
            </div>
            <div class="container-fluid">
                <table class="table" id="scoreTable">
                    <thead>
                    <tr>
                        <th>姓名</th>
                        <th>得分</th>
                        <th>地区</th>
                        <th></th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

    <div class="col-sm-4">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h5>调整统计图</h5>
            </div>
            <div class="panel-body">
                <div class="form-group form-inline">
                    <input type="text" class="form-control" name="100up" value="100"/>
                    <input type="text" class="form-control" name="80up" value="80"/>
                    <button class="btn btn-primary" id="submit" >
                        <i class="fa fa-check"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/dataTables.bootstrap.min.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.dataTables.min.js"></script>
<script src="<?= THEMEPATH ?>/js/dataTables.bootstrap.min.js"></script>
<script src="<?= THEMEPATH ?>/js/echarts.min.js"></script>

<script type="text/javascript">
    $(function () {
        var table = $('#scoreTable').DataTable({
            language: {
                'url': '<?=THEMEPATH?>/js/dataTables.zh-CN.json'
            },
            "processing": true,
            "serverSide": true,
            'searching': true,
            "ajax": "<?= site_url("/admin/stat/table/{$room}") ?>",
            order: [[1, 'desc']],
            "columns": [
                {"data": "user_name"},
                {"data": "score"},
                {"data": "city_name"},
                {"data": "action"}
            ],
            'columnDefs': [{
                'orderable': false,//禁用排序
                'targets': [3]   //指定的列
            }]
        });

        var option = {
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'shadow'
                }
            },
            legend: {
                data: ['100以上', '100～80', '80以下']
            },
            grid: {
                left: '3%',
                right: '4%',
                bottom: '3%',
                containLabel: true
            },
            xAxis: [
                {
                    type: 'category',
                    data: <?=json_encode($cities)?>,
                    axisTick: {
                        alignWithLabel: true
                    }
                }
            ],
            yAxis: {
                type: 'value'
            }
            ,
            series: [
                {
                    name: '100以上',
                    type: 'bar',
                    data: <?=json_encode($s100)?>
                },
                {
                    name: '100～80',
                    type: 'bar',
                    data: <?=json_encode($s80)?>
                },
                {
                    name: '80以下',
                    type: 'bar',
                    data: <?=json_encode($s0)?>
                }]
        };
        var myChart = echarts.init(document.getElementById('score'));
        myChart.setOption(option);

        $('#submit').click(function () {
            var s100=$('input[name=100up]').val();
            var s80=$('input[name=80up]').val();
            $.post('<?=site_url('admin/stat/get/'.$room)?>',{'100up':s100,'80up':s80}, function (data) {
                var e= $.parseJSON(data);
                myChart.setOption({
                    legend: {
                        data: [s100+'以上', s100+'～'+s80, s80+'以下']
                    },
                    series: [
                        {
                            name: s100+'以上',
                            type: 'bar',
                            data: e.s100
                        },
                        {
                            name: s100+'～'+s80,
                            type: 'bar',
                            data: e.s80
                        },
                        {
                            name: s80+'以下',
                            type: 'bar',
                            data: e.s0
                        }
                    ]
                });
            })
        });

        $('#scoreTable').on('click', '.viewTest', function () {
            var id = $(this).parents('tr').attr('id');
            var opt = 'top=0, left=0, toolbar=no, menubar=no, scrollbars=yes, resizable=no,location=no, status=no';
            var tmp = window.open("<?=site_url('test/view')?>/" + id, "_blank", opt);
            tmp.moveTo(0, 1);
            tmp.resizeTo(screen.availWidth, screen.availHeight);
            tmp.focus();
        });
    });
</script>
