<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row">
            <div class="col-md-6">
                <h5>考场列表</h5>
            </div>
            <div class="col-md-6 text-right">
                <div class=" btn-group">
                    <button class="btn btn-default" id="addroom" title="增加试题">
                        <i class="fa fa-plus"></i>
                    </button>
                    <button class="btn btn-danger" id="deleteroom" title="删除所选">
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
            </div>
        </div>

    </div>

    <div class="container-fluid">
        <table class="table" id="roomTable">
            <thead>
            <tr>
                <th width="10px">
                    <input type="checkbox" id="checkAll"/>
                </th>
                <th width="20px">ID</th>
                <th>名称</th>
                <th>考试时间</th>
                <th>参考地区</th>
                <th>参考用户组</th>
                <th>状态</th>
                <th width="80px">操作</th>
            </tr>
            </thead>
        </table>
    </div>
</div>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/dataTables.bootstrap.min.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.dataTables.min.js"></script>
<script src="<?= THEMEPATH ?>/js/dataTables.bootstrap.min.js"></script>

<script type="text/javascript">
    $(function () {
        var table = $('#roomTable').DataTable({
            language: {
                'url': '<?=THEMEPATH?>/js/dataTables.zh-CN.json'
            },
            "processing": true,
            "serverSide": true,
            'searching': true,
            "ajax": "<?= site_url('/admin/room/table/') ?>",
            order: [[1, 'desc']],
            "columns": [
                {"data": "checkbox"},
                {"data": "id"},
                {"data": "name"},
                {"data": "time"},
                {"data": "city_name"},
                {"data": "group"},
                {"data": "stat"},
                {"data": "action"}
            ],
            'columnDefs': [{
                'orderable': false,//禁用排序
                'targets': [0, 7]   //指定的列
            }],
            "createdRow": function (row, data) {

                if (data.group == null) {
                    $('td', row).eq(5).text("所有小组");
                } else {
                    var text='';
                    var group= $.parseJSON(data.group);
                    for (var i in group) {
                        if (group[i])
                            text+=" "+group[i].name;
                    }
                    $('td', row).eq(5).text(text);
                }
                switch (data.stat) {
                    case '0':
                        $('td', row).eq(6).text("考试");
                        break;
                    case '1':
                        $('td', row).eq(6).text("练习");
                        break;
                }
            }
        });

        $('#addroom').click(function () {
            $('.main-content').load('<?=site_url('admin/room/add')?>');
        });

        $('#roomTable').on('click', '.editRoom', function () {
            var id = $(this).parents('tr').attr('id');
            $('.main-content').load('<?=site_url('admin/room/add')?>/' + id);
        });

        $('#roomTable').on('click', '.deleteRoom', function () {
            if (!confirm("删除考场将删除此考场的所有考试记录.\n确认删除此考场？")) return false;
            var id = $(this).parents('tr').attr('id');
            $.post('<?=site_url('admin/room/delete')?>/', {'id': id}, function (data) {
                var e = $.parseJSON(data);
                if (e.error) {
                    show_error(e.error)
                } else {
                    show_error(e.success);
                    table.row('#' + id).remove().draw(false);
                }
            });
        });

        $('#deleteroom').click(function () {
            if (!confirm("确认删除所选考场？")) return false;
            var chk_value = [];
            $('input[name="check"]:checked').each(function () {
                chk_value.push($(this).parents('tr').attr('id'));
            });
            $.post('<?=site_url('admin/room/delete')?>/', {'id': chk_value}, function (data) {
                var e = $.parseJSON(data);
                if (e.error) {
                    show_error(e.error)
                } else {
                    show_error(e.success);
                    for (var id in chk_value)
                        table.row('#' + id).remove();
                    table.draw(false);
                }
            });
        });

        $('#checkAll').click(function () {
            $('tr :checkbox').prop('checked', $(this).prop('checked'));
        });
    });
</script>