<div class="panel panel-default">
    <div class="panel-body">
        <form class="form-horizontal" id="roomForm" action="<?= site_url('admin/room/edit') ?>" method="post">

            <div class="pull-right">
                <div class="btn-group">
                    <button class="btn btn-primary" type="submit" title="保存试卷">
                        <i class="fa fa-save"></i>
                    </button>
                    <button class="btn btn-info" type="button" id="back" title="返回列表">
                        <i class="fa fa-mail-reply"></i>
                    </button>
                </div>
            </div>
            <!-- Nav tabs -->
            <ul class="nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#home" role="tab" data-toggle="tab">
                        <?= isset($room) ? '编辑' : '增加' ?>考场
                    </a>
                </li>
            </ul>

            <?php if (isset($room)): ?>
                <input type="hidden" name="id" value="<?= $room['id'] ?>"/>
            <?php endif; ?>

            <!-- Tab panes -->
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">考场名称</label>

                        <div class="col-sm-8">
                            <input type="text" class="form-control" data-required="true" name="name" value="<?= isset($room) ? $room['name'] : '' ?>"/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">开考时间</label>

                        <div class="col-sm-8">
                            <input type="text" class="form-control" data-required="true" name="time" value="<?= isset($room) ? $room['time'] : '' ?>"/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">进场时间</label>

                        <div class="col-sm-8">
                            <input type="text" class="form-control" data-required="true" name="start" value="<?= isset($room) ? $room['start'] : '0' ?>"/>
                            <small>最迟进入考场时间，以分钟为单位，0为不限制。</small>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">考试试卷</label>

                        <div class="col-sm-8">
                            <select name="page" class="form-control">
                                <?php foreach ($pages as $p) { ?>
                                    <option value="<?= $p['id'] ?>" <?= isset($room) && $room['page'] == $p['id'] ? 'selected' : '' ?>><?= $p['name'] ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">参考地区</label>
                        <input type="hidden" name="city" value="<?= isset($room) ? $room['city'] : '' ?>"/>

                        <div class="col-sm-8">
                            <div class="div-bor">
                                <i class="fa fa-caret-down"></i>
                                <input type="text" class="form-control" name="cityName" value="<?= isset($room) ? $room['city_name'] : '所有地区' ?>" readonly/>
                            </div>
                            <div class="relative" style="display: none;">
                                <div class="jtree" id="selectCity">
                                    <div class="absolute" id="0">
                                        <li >
                                            <i class="fa fa-square"></i>
                                            <span class="nodeName">所有地区</span>
                                        </li>
                                    </div>
                                </div>
                            </div>
                            <span class="small">参考地区、小组可以不选择，如果留空将为所有地区、小组都可以参加。</span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">考场状态</label>

                        <div class="col-sm-8">
                            <select name="stat" class="form-control">
                                <option value="0" <?= isset($room) && $room['stat'] == 0 ? 'selected' : '' ?>>考试</option>
                                <option value="1" <?= isset($room) && $room['stat'] == 1 ? 'selected' : '' ?>>练习</option>
                            </select>
                            <small>状态为练习的考场，可以不限进入，只记录最后一次得分、试卷。</small>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">参考小组</label>

                        <div class="col-sm-8">
                            <select name="group[]" class="form-control" multiple id="selectGroup">
                                <option value="0">所有小组</option>
                                <?php foreach ($groups as $g) { ?>
                                    <option value="<?= $g['id'] ?>"><?= $g['name'] ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>

                </div>
            </div>
        </form>
    </div>
</div>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/jquery.jtree.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/bootstrap-datetimepicker.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/bootstrap-duallistbox.min.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.bootstrap-duallistbox.min.js"></script>
<script src="<?= THEMEPATH ?>/js/bootstrap-datetimepicker.js"></script>
<script src="<?= THEMEPATH ?>/js/bootstrap-datetimepicker.zh-CN.js"></script>
<script src="<?= THEMEPATH ?>/js/jquery.jtree.js"></script>
<script src="<?= THEMEPATH ?>/js/validator.js"></script>

<script type="text/javascript">
    $(function () {
        var node = <?=json_encode($cities, JSON_UNESCAPED_UNICODE)?>;
        $('#selectCity').jtree({
            data: node,
            height: 200,
            button: false,
            select: true,
            close: false,
            selectID: '<?=isset($room)?$room['city']:''?>',
            nodeAction: function (id, text) {
                $('input[name=city]').val(id);
                $('input[name=cityName]').val(text);
            }
        });

        $('input[name=time]').datetimepicker({'language': 'zh-CN', minView: 0, autoclose: true});

        $('input[name=cityName]').focus(function () {
            $('#selectCity').parent('div').slideDown();
        });

        $('input[name=cityName]').blur(function () {
            $('#selectCity').parent('div').slideUp();
        });

        $('#back').click(function () {
            window.location.href = '<?=site_url('/')?>'
        });

        <?php if (isset($room)) {
            if ($room['group']==null) {
        ?>
        $('#selectGroup').find('option[value=0]').attr('selected', true);
        <?php } else {?>
        var groups = <?=$room['group']?>;
        for (var i in groups) {
            $('#selectGroup').find('option[value=' + groups[i].id + ']').attr('selected', true);
        }

        <?php }} ?>
        $('#selectGroup').bootstrapDualListbox({
            'infoText': false,
            'infoTextEmpty': false,
            'showFilterInputs': false,
            'selectorMinimalHeight': 320
        });

        $('#roomForm').formValidator({
            before: function () {
                var group = $('select[name=group]').val();
                if ($.inArray('0', group) != -1 && group.length > 1) {
                    show_error('已经选择了 所有小组，请删除其它小组。')
                    return false;
                }
            },
            sending: {
                type: 'ajax',
                success: function (data) {
                    var e = $.parseJSON(data);
                    if (e.error) {
                        show_error({'message': e.error});
                    } else {
                        show_error(e.success);
                        window.location.href = '<?=site_url("/")?>';
                    }
                },
                error: function () {
                    show_error('提交表单失败！');
                }
            }
        });
    })
    ;
</script>