<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row">
            <div class="col-md-6">
                <h5>试题列表</h5>
            </div>
            <div class="col-md-6 text-right">
                <div class=" btn-group">
                    <button class="btn btn-default" id="addQuestion" title="增加试题">
                        <i class="fa fa-plus"></i>
                    </button>
                    <button class="btn btn-default" data-open="<?= site_url("admin/import") ?>" title="导入试题">
                        <i class="fa fa-upload"></i>
                    </button>
                    <button class="btn btn-default" id="exportQuestion" title="导出所选">
                        <i class="fa fa-download"></i>
                    </button>
                    <button class="btn btn-danger" id="deleteQuestions" title="删除所选">
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
            </div>
        </div>

    </div>

    <div class="container-fluid">
        <table class="table" id="questionTable">
            <thead>
            <tr>
                <th width="10px">
                    <input type="checkbox" id="checkAll"/>
                </th>
                <th width="20px">ID</th>
                <th width="60%">题干</th>
                <th>类型</th>
                <th>分类</th>
                <th>日期</th>
                <th width="80px">操作</th>
            </tr>
            </thead>
        </table>
    </div>
</div>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/dataTables.bootstrap.min.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.dataTables.min.js"></script>
<script src="<?= THEMEPATH ?>/js/dataTables.bootstrap.min.js"></script>

<script type="text/javascript">
    $(function () {
        var table = $('#questionTable').DataTable({
            language: {
                'url': '<?=THEMEPATH?>/js/dataTables.zh-CN.json'
            },
            'stateSave': false,
            "processing": true,
            "serverSide": true,
            'searching': true,
            "ajax": "<?= site_url('/admin/question/table/') ?>",
            order: [[1, 'desc']],
            "columns": [
                {"data": "checkbox"},
                {"data": "id"},
                {"data": "name"},
                {"data": "type_name"},
                {"data": "category_name"},
                {"data": "date"},
                {"data": "action"}
            ],
            'columnDefs': [{
                'orderable': false,//禁用排序
                'targets': [0, 6]   //指定的列
            }],
            "createdRow": function (row, data, index) {
                var url = $('<a>', {
                    'href': 'javascript:void(0);',
                    'data-open': '<?= site_url('admin/question/view/')?>/' + data.id,
                    'title': '详细内容',
                    'text': $('td', row).eq(2).text()
                });
                $('td', row).eq(2).html(url);

            }
        });

        $('#addQuestion').click(function () {
            $('.main-content').load('<?=site_url('admin/question/add')?>');
        });

        $('#questionTable').on('click', '.editQuestion', function () {
            var id = $(this).parents('tr').attr('id');
            $('.main-content').load('<?=site_url('admin/question/add')?>/' + id);
        });

        $('#questionTable').on('click', '.deleteQuestion', function () {
            if (!confirm("确认删除此题目？")) return false;
            var id = $(this).parents('tr').attr('id');
            $.post('<?=site_url('admin/question/delete')?>/', {'id': id}, function (data) {
                var e = $.parseJSON(data);
                if (e.error) {
                    show_error(e.error)
                } else {
                    show_error(e.success);
                    table.row('#' + id).remove().draw(false);
                }
            });
        });

        $('#deleteQuestions').click(function () {
            if (!confirm("确认删除所选题目？")) return false;
            var chk_value = [];
            $('input[name="check"]:checked').each(function () {
                chk_value.push($(this).parents('tr').attr('id'));
            });
            $.post('<?=site_url('admin/question/delete')?>/', {'id': chk_value}, function (data) {
                var e = $.parseJSON(data);
                if (e.error) {
                    show_error(e.error)
                } else {
                    show_error(e.success);
                    for (var id in chk_value)
                        table.row('#' + id).remove();
                    table.draw(false);
                }
            });
            $(':checked').prop('checked',false);
        });

        $('#checkAll').click(function () {
            $('tr :checkbox').prop('checked', $(this).prop('checked'));
        });
    });
</script>