<div class="panel panel-default">
    <div class="panel-body">
        <form class="form-horizontal" id="questionFrom" action="<?= site_url('admin/question/edit') ?>" method="post">

            <div class="pull-right">
                选择留在此页，保存后将不跳转页面。
                <div class="btn-group">
                    <button class="btn btn-primary" type="submit">
                        <i class="fa fa-save"></i>
                    </button>
                    <button class="btn btn-info" type="button" id="back" title="返回列表">
                        <i class="fa fa-mail-reply"></i>
                    </button>
                </div>
            </div>
            <!-- Nav tabs -->
            <ul class="nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#home" role="tab" data-toggle="tab">
                        <?= isset($question) ? '编辑' : '增加' ?>试题
                    </a>
                </li>
                <li>
                    <input type="checkbox" <?= isset($question) ?'':'checked'?> id="stay" title="留在此页"/>
                </li>
            </ul>

            <?php if (isset($question)): ?>
                <input type="hidden" name="id" value="<?= $question['id'] ?>"/>
            <?php endif; ?>

            <!-- Tab panes -->
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">类别</label>
                        <input type="hidden" name="category" value="<?= isset($question) ? $question['category'] : '' ?>"/>

                        <div class="col-sm-8">
                            <div class="div-bor">
                                <i class="fa fa-caret-down"></i>
                                <input type="text" class="form-control" name="categoryName" value="<?= isset($category) ? $category['name'] : '' ?>" readonly/>
                            </div>
                            <div class="relative" style="display: none;" id="selectCategory">
                                <div class="jtree absolute" id="0"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">题型</label>

                        <div class="col-sm-8">
                            <select name="type" class="form-control" id="type">
                                <?php foreach ($types as $type): ?>
                                    <option value="<?= $type['id'] ?>" <?= isset($question) && $question['type'] == $type['id'] ? "selected" : '' ?>><?= $type['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">难易</label>

                        <div class="col-sm-8">
                            <select name="level" class="form-control">
                                <option value="0">易</option>
                                <option value="1">难</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">题干</label>

                        <div class="col-sm-8">
                            <textarea data-required="true" name="name" class="form-control">
                                <?= isset($question) ? trim($question['name']) : '' ?>
                            </textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">
                            选项/答案<br>

                            <div class="btn-group">
                                <button class="btn btn-sm" id="addOption" type="button">
                                    <i class="fa fa-plus"></i>
                                </button>
                                <button class="btn btn-sm" id="deleteOption" type="button">
                                    <i class="fa fa-minus"></i>
                                </button>
                            </div>
                        </label>

                        <div class="col-sm-8 form-inline">
                            <ol type="A" id="options">
                                <?php if (isset($question)) {
    if ($question['type'] != 5) {
        switch ($question['type']) {
                                            case 1:
                                            case 3:
                                                $input = 'radio';
                                                break;
                                            case 2:
                                            case 4:
                                                $input = 'checkbox';
                                        }
        $i = 0;
        if (is_array(json_decode($question['option'], true))) {
            foreach (json_decode($question['option'], true) as $option) {
                ?>
                                                <li>
                                                    <input type="text" name="option[]" value="<?= $option['t'] ?>" class="form-control" style="width:70%"/>
                                                    <input type="<?= $input ?>" name="answer[]" <?= (isset($option['a']) && $option['a'] == 't') ? "checked" : '' ?> class="form-control" value="<?= $i ?>"/>
                                                </li>
                                                <?php
                                                $i++;
            }
        }
    } else {
        echo '<textarea name="option" class="form-control">';
        echo $question['option'];
        echo '</textarea>';
    }
} else {
    ?>
                                    <li>
                                        <input type="text" name="option[]" class="form-control" style="width:70%"/>
                                        <input type="radio" name="answer[]" class="form-control" value="0"/>
                                    </li>
                                    <li>
                                        <input type="text" name="option[]" class="form-control" style="width:70%"/>
                                        <input type="radio" name="answer[]" class="form-control" value="1"/>
                                    </li>
                                    <li>
                                        <input type="text" name="option[]" class="form-control" style="width:70%"/>
                                        <input type="radio" name="answer[]" class="form-control" value="2"/>
                                    </li>
                                    <li>
                                        <input type="text" name="option[]" class="form-control" style="width:70%"/>
                                        <input type="radio" name="answer[]" class="form-control" value="3"/>
                                    </li>
                                <?php

} ?>
                            </ol>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">解析</label>

                        <div class="col-sm-8">
                            <textarea name="analysis" class="form-control">
                                <?= isset($question) ? $question['analysis'] : '' ?>
                            </textarea>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/summernote.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/jquery.jtree.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.jtree.js"></script>
<script src="<?= THEMEPATH ?>/js/summernote.min.js"></script>
<script src="<?= THEMEPATH ?>/js/summernote-zh-CN.min.js"></script>
<script src="<?= THEMEPATH ?>/js/validator.js"></script>

<script type="text/javascript">
    $(function () {
        $('textarea[name=name]').summernote({
            'lang': 'zh-CN',
            'height': 130
        });
        $('textarea[name=analysis]').summernote({
            'lang': 'zh-CN',
            'height': 130
        });

        $('#back').click(function () {
            window.location.href = '<?=site_url('/')?>'
        });

        var node = <?=json_encode($categories, JSON_UNESCAPED_UNICODE)?>;
        $('#selectCategory').jtree({
            data: node,
            height: 200,
            button: false,
            select: true,
            close: false,
            selectID: '<?=isset($question)?$question['category']:''?>',
            nodeAction: function (id, text) {
                $('input[name=category]').val(id);
                $('input[name=categoryName]').val(text);
            }
        });

        $('input[name=categoryName]').focus(function () {
            $('#selectCategory').slideDown();
        });

        $('input[name=categoryName]').blur(function () {
            $('#selectCategory').slideUp();
        });

        $('#type').change(function () {
            var type = $(this).val();
            var options = $('#options');
            var text = $('#options').find(':text');
            options.html('');
            switch (type) {
                case '1':
                    text.each(function (k) {
                        var value = $(this).val();
                        var li = $('<li>').append(
                            $('<input>', {
                                'type': 'text',
                                'name': 'option[]',
                                'class': 'form-control',
                                'style': 'width:70%',
                                'value': value
                            })
                        ).append(
                            $('<input>', {'type': 'radio', 'name': 'answer[]', 'class': 'form-control', 'value': k})
                        );
                        options.append(li);
                    });
                    break;
                case '2':
                    text.each(function (k) {
                        var value = $(this).val();
                        var li = $('<li>').append(
                            $('<input>', {
                                'type': 'text',
                                'name': 'option[]',
                                'class': 'form-control',
                                'style': 'width:70%',
                                'value': value
                            })
                        ).append(
                            $('<input>', {'type': 'checkbox', 'name': 'answer[]', 'class': 'form-control', 'value': k})
                        );
                        options.append(li);
                    });
                    break;
                case '3':
                    var li = $('<li>').append(
                        $('<input>', {
                            'type': 'text',
                            'name': 'option[]',
                            'class': 'form-control',
                            'style': 'width:40px',
                            'value': '正确',
                            'disabled': 'true'
                        })
                    ).append(
                        $('<input>', {
                            'type': 'radio',
                            'name': 'answer[]',
                            'class': 'form-control',
                            'value': 0,
                            'checked': true
                        })
                    );
                    options.append(li);
                    var li = $('<li>').append(
                        $('<input>', {
                            'type': 'text',
                            'name': 'option[]',
                            'class': 'form-control',
                            'style': 'width:40px',
                            'value': '错误',
                            'disabled': 'true'
                        })
                    ).append(
                        $('<input>', {'type': 'radio', 'name': 'answer[]', 'class': 'form-control', 'value': 1})
                    );
                    options.append(li);

                    break;
                case '4':
                    for (var i = 0; i < 2; i++) {
                        var li = $('<li>').append(
                            $('<input>', {
                                'type': 'text',
                                'name': 'option[]',
                                'class': 'form-control',
                                'style': 'width:70%'
                            })
                        ).append(
                            $('<input>', {
                                'type': 'checkbox',
                                'name': 'answer[]',
                                'class': 'form-control hide',
                                'value': i,
                                'checked': true
                            })
                        );
                        options.append(li);
                    }
                    break;
                case '5':
                    var text = $("<textarea>", {
                        'name': 'option',
                        'class': 'form-control',
                        'style': 'width:100%',
                        'placeholder': "请输入答案"
                    });
                    options.html('').append(text);
                    break;
            }
        });

        $('#addOption').click(function () {
            var size = $('#options').find('li').length;
            var type = $('select[name=type]').val();
            var choice = (type == 1 || type==3) ? 'radio' : 'checkbox';

            if (type == 5) return;

            if (type==3 && $('#options').find('li').length >=2 ) return;

            var li = $('<li>').append(
                $('<input>', {
                    'type': 'text',
                    'name': 'option[]',
                    'class': 'form-control',
                    'style': 'width:70%'
                })
            ).append(
                $('<input>', {
                    'type': choice,
                    'name': 'answer[]',
                    'class': 'form-control',
                    'value': size
                })
            );
            $('#options').append(li);
        });

        $('#deleteOption').click(function () {
            $('#options li:last').remove();
        })

        $('#questionFrom').formValidator({
            sending: {
                type: 'ajax',
                success: function (data) {
                    var e = $.parseJSON(data);
                    if (e.error) {
                        show_error({'message': e.error});
                    } else {
                        show_error(e.success);
                        if ($('#stay').prop('checked') == false) {
                            $('.main-content').load('<?=site_url('admin/question')?>');
                        } else {
                            $('#questionFrom').find('input:text:not([name=categoryName])').val('');
                            //$('#questionFrom').find('textarea').val('');
                            $('textarea[name=name]').summernote('reset');
                            $('textarea[name=analysis]').summernote('reset');
                        }
                    }
                },
                error: function () {
                    show_error('提交表单失败！');
                }
            }
        });
    })
    ;
</script>
