<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row">
            <div class="col-md-6">
                <h5>试卷列表</h5>
            </div>
            <div class="col-md-6 text-right">
                <div class=" btn-group">
                    <button class="btn btn-default" id="addPage" title="增加试题">
                        <i class="fa fa-plus"></i>
                    </button>
                    <button class="btn btn-danger" id="deletePage" title="删除所选">
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
            </div>
        </div>

    </div>

    <div class="container-fluid">
        <table class="table" id="pageTable">
            <thead>
            <tr>
                <th width="10px">
                    <input type="checkbox" id="checkAll"/>
                </th>
                <th width="20px">ID</th>
                <th>名称</th>
                <th>考试科目</th>
                <th>组卷类型</th>
                <th>打乱选项顺序</th>
                <th>组卷人</th>
                <th>日期</th>
                <th width="80px">操作</th>
            </tr>
            </thead>
        </table>
    </div>
</div>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/dataTables.bootstrap.min.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.dataTables.min.js"></script>
<script src="<?= THEMEPATH ?>/js/dataTables.bootstrap.min.js"></script>

<script type="text/javascript">
    $(function () {
        var table = $('#pageTable').DataTable({
            language: {
                'url': '<?=THEMEPATH?>/js/dataTables.zh-CN.json'
            },
            "processing": true,
            "serverSide": true,
            'searching': true,
            "ajax": "<?= site_url('/admin/page/table/') ?>",
            order: [[1, 'desc']],
            "columns": [
                {"data": "checkbox"},
                {"data": "id"},
                {"data": "name"},
                {"data": "category_name"},
                {"data": "type"},
                {"data": "upset"},
                {"data": "user_name"},
                {"data": "date"},
                {"data": "action"}
            ],
            'columnDefs': [{
                'orderable': false,//禁用排序
                'targets': [0, 8]   //指定的列
            }],
            "createdRow": function (row, data) {
                switch (data.upset) {
                    case '0':
                        $('td', row).eq(5).text("否");
                        break;
                    case '1':
                        $('td', row).eq(5).text("是");
                        break;
                }
                switch (data.type) {
                    case '0':
                        $('td', row).eq(4).text("随机");
                        break;
                    case '1':
                        $('td', row).eq(4).text("手工");
                        break;
                }
            }
        });

        $('#addPage').click(function () {
            $('.main-content').load('<?=site_url('admin/page/add')?>');
        });

        $('#pageTable').on('click', '.editPage', function () {
            var id = $(this).parents('tr').attr('id');
            $('.main-content').load('<?=site_url('admin/page/add')?>/' + id);
        });

        $('#pageTable').on('click', '.deletePage', function () {
            if (!confirm("确认删除此试卷？")) return false;
            var id = $(this).parents('tr').attr('id');
            $.post('<?=site_url('admin/page/delete')?>/', {'id': id}, function (data) {
                var e = $.parseJSON(data);
                if (e.error) {
                    show_error(e.error)
                } else {
                    show_error(e.success);
                    table.row('#' + id).remove().draw(false);
                }
            });
        });

        $('#deletePage').click(function () {
            if (!confirm("确认删除所选试卷？")) return false;
            var chk_value = [];
            $('input[name="check"]:checked').each(function () {
                chk_value.push($(this).parents('tr').attr('id'));
            });
            $.post('<?=site_url('admin/page/delete')?>/', {'id': chk_value}, function (data) {
                var e = $.parseJSON(data);
                if (e.error) {
                    show_error(e.error)
                } else {
                    show_error(e.success);
                    for (var id in chk_value)
                        table.row('#' + id).remove();
                    table.draw(false);
                }
            });
        });

        $('#checkAll').click(function () {
            $('tr :checkbox').prop('checked', $(this).prop('checked'));
        });
    });
</script>