<div class="panel panel-default">
    <div class="panel-body">
        <form class="form-horizontal" id="pageForm" action="<?= site_url('admin/page/edit') ?>" method="post">

            <div class="pull-right">
                <div class="btn-group">
                    <button class="btn btn-primary" type="submit" title="保存试卷">
                        <i class="fa fa-save"></i>
                    </button>
                    <button class="btn btn-info" type="button" id="back" title="返回列表">
                        <i class="fa fa-mail-reply"></i>
                    </button>
                </div>
            </div>
            <!-- Nav tabs -->
            <ul class="nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#home" role="tab" data-toggle="tab">
                        <?= isset($page) ? '编辑' : '增加' ?>试卷
                    </a>
                </li>
            </ul>

            <?php if (isset($page)): ?>
                <input type="hidden" name="id" value="<?= $page['id'] ?>"/>
            <?php endif; ?>

            <!-- Tab panes -->
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">试卷名称</label>

                        <div class="col-sm-8">
                            <input type="text" class="form-control" data-required="true" name="name" value="<?= isset($page) ? $page['name'] : '' ?>"/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">考试科目</label>
                        <input type="hidden" name="category" value="<?= isset($page) ? $page['category'] : '' ?>"/>

                        <div class="col-sm-8">
                            <div class="div-bor">
                                <i class="fa fa-caret-down"></i>
                                <input type="text" class="form-control" name="categoryName" value="<?= isset($category) ? $category['name'] : '' ?>" readonly/>
                            </div>
                            <div class="relative" style="display: none;" id="selectCategory">
                                <div class="jtree absolute" id="0"></div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">组卷方式</label>

                        <div class="col-sm-8">
                            <select name="type" class="form-control">
                                <option value="0" <?= isset($page) && $page['type'] == 0 ? 'selected' : '' ?>>随机</option>
                                <option value="1" <?= isset($page) && $page['type'] == 1 ? 'selected' : '' ?>>手工</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">打乱选项顺序</label>

                        <div class="col-sm-8">
                            <select name="upset" class="form-control">
                                <option value="0" <?= isset($page) && $page['upset'] == 0 ? 'selected' : '' ?>>否</option>
                                <option value="1" <?= isset($page) && $page['upset'] == 1 ? 'selected' : '' ?>>是</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">考试时长</label>

                        <div class="col-sm-8">
                            <input type="text" class="form-control" data-required="true" name="time" value="<?= isset($page) ? $page['time'] : '' ?>"/>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">试卷总分</label>

                        <div class="col-sm-8">
                            <input type="text" class="form-control" data-required="true" name="total" value="<?= isset($page) ? $page['total'] : '' ?>"/>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">及格线</label>

                        <div class="col-sm-8">
                            <input type="text" class="form-control" data-required="true" name="passing" value="<?= isset($page) ? $page['passing'] : '' ?>"/>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">选题</label>

                        <div class="col-sm-8 form-inline" id="question">
                            <label data-type="1">
                                <strong class="title">单选题</strong>：共<input type="text" class="form-control text-center num" name="num[]" value="0"/>题，
                                每题<input type="text" class="form-control text-center score" name="score[]" value="0"/>分
                            </label>
                            <label data-type="2">
                                <strong class="title">多选题</strong>：共<input type="text" class="form-control text-center num" name="num[]" value="0"/>题，
                                每题<input type="text" class="form-control text-center score" name="score[]" value="1"/>分
                            </label>
                            <label data-type="3">
                                <strong class="title">判断题</strong>：共<input type="text" class="form-control text-center num" name="num[]" value="0"/>题，
                                每题<input type="text" class="form-control text-center score" name="score[]" value="1"/>分
                            </label>
                            <label data-type="4">
                                <strong class="title">填空题</strong>：共<input type="text" class="form-control text-center num" name="num[]" value="0"/>题，
                                每题<input type="text" class="form-control text-center score" name="score[]" value="0"/>分
                            </label>
                            <label data-type="5">
                                <strong class="title">问答题</strong>：共<input type="text" class="form-control text-center num" name="num[]" value="0"/>题，
                                每题<input type="text" class="form-control text-center score" name="score[]" value="0"/>分
                            </label>
                        </div>
                    </div>

                </div>
            </div>
        </form>
    </div>
</div>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/summernote.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/jquery.jtree.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.jtree.js"></script>
<script src="<?= THEMEPATH ?>/js/summernote.min.js"></script>
<script src="<?= THEMEPATH ?>/js/summernote-zh-CN.min.js"></script>
<script src="<?= THEMEPATH ?>/js/validator.js"></script>

<script type="text/javascript">
    $(function () {
        var node = <?=json_encode($categories, JSON_UNESCAPED_UNICODE)?>;
        $('#selectCategory').jtree({
            data: node,
            height: 200,
            button: false,
            select: true,
            close: false,
            selectID: '<?=isset($page)?$page['category']:''?>',
            nodeAction: function (id, text) {
                $('input[name=category]').val(id);
                $('input[name=categoryName]').val(text);
            }
        });

        $('input[name=categoryName]').focus(function () {
            $('#selectCategory').slideDown();
        });

        $('input[name=categoryName]').blur(function () {
            $('#selectCategory').slideUp();
        });

        $('#back').click(function () {
            window.location.href = '<?=site_url('/')?>'
        });

        <?php if (isset($page)) {?>
        var ques =<?=$page['question']?>;
        $('#question').find('label').each(function (i) {
            var num = 0, score = 0, qu = '[]', qunum = 0;
            if (ques[i + 1]) {
                num = ques[i + 1].n;
                score = ques[i + 1].s;
            } else {return;}
            $(this).find('.num').val(num);
            $(this).find('.score').val(score);
            <?php if ($page['type']==1) {?>
            if (quest[i + 1]) {
                qu = ques[i + 1].q;
                qunum = $.parseJSON(ques[i + 1].q).length;
            }
            var button = $('<button>', {
                'class': 'btn btn-default selectQ',
                'type': 'button'
            }).append($('<i>', {'class': "fa fa-magic"})).append(' 选题');
            var input = $('<input>', {'type': 'hidden', 'name': 'ques[]', 'value': qu});
            var span = $('<span>').html('，目前选择&nbsp;<b>' + qunum + '</b>&nbsp;题&nbsp;&nbsp;');
            $(this).append(span).append(input).append(button);
            <?php } ?>

        });
        <?php }?>
        $('select[name=type]').change(function () {
            var type = $(this).val();
            if (type == 1) {
                var button = $('<button>', {
                    'class': 'btn btn-default selectQ',
                    'type': 'button'
                }).append($('<i>', {'class': "fa fa-magic"})).append(' 选题');
                var input = $('<input>', {'type': 'hidden', 'name': 'ques[]', 'value': '[]'});
                var span = $('<span>').html('，目前选择&nbsp;<b>0</b>&nbsp;题&nbsp;&nbsp;');
                $('#question').find('label').append(span).append(input).append(button);
            } else {
                $('#question').find('button').remove();
                $('#question').find('span').remove();
                $('#question').find('input[type=hidden]').remove();
            }
        });

        $('#pageForm').on('click', '.selectQ', function () {
            var type = $(this).parent('label').data('type');
            var category = $('input[name=category]').val();

            if (!category) {
                show_error('请先选择考试科目后重试。');
                return false;
            }
            ajax_dialog('选择题目', '<?=site_url('admin/question/select')?>/' + category + '/' + type);
        });

        $('#pageForm').formValidator({
            before: function () {
                //计算分数是否合理
                var t = $('input[name=total]').val();
                var total = 0;
                var s = 0;
                var message = [];
                $('#question').find('label').each(function () {
                    var num = $(this).children('.num').val();
                    var score = $(this).children('.score').val();
                    total += num * score;
                    //如果是手工组卷，检查选题是否合理
                    if ($('select[name=type]').val() == 1) {
                        var n = $(this).find('b').text();
                        if (n != num) {
                            message.push($(this).find('strong').text() + " 总题量与手工选题不相符。<br>")
                            s = 1;
                        }
                    }
                });
                if (t != total) {
                    show_error('输入的总分与选题总分不符合。');
                    return false;
                }
                if (s == 1) {
                    show_error({'message': message, 'color': 'danger'});
                    return false;
                }

            },
            sending: {
                type: 'ajax',
                success: function (data) {
                    var e = $.parseJSON(data);
                    if (e.error) {
                        show_error({'message': e.error});
                    } else {
                        show_error(e.success);
                        window.location.href = '<?=site_url("/")?>';
                    }
                },
                error: function () {
                    show_error('提交表单失败！');
                }
            }
        });
    })
    ;
</script>