<div class="row">
    <div class="col-md-6">
        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-md-6">
                        <h5>分组列表</h5>
                    </div>
                    <div class="col-md-6 text-right">
                        <div class=" btn-group">
                            <button class="btn btn-primary" data-open="<?= site_url('admin/group/add') ?>" title="增加分组" data-size="m">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>
                </div>

            </div>

            <div class="container-fluid">
                <table class="table" id="groupTable">
                    <thead>
                    <tr>
                        <th width="20px">ID</th>
                        <th>组名</th>
                        <th width="80px">操作</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <form class="form-horizontal" id="selectForm" method="post" action="<?= site_url('admin/group/select') ?>">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-md-6">
                            <h5>用户分组</h5>
                        </div>
                        <div class="col-md-6 text-right">
                            <div class=" btn-group">
                                <button class="btn btn-primary" type="submit" title="保存分组">
                                    <i class="fa fa-save"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="panel-body">
                    <div class="form-group">
                        <label for="email" class="col-sm-2 control-label">分组</label>

                        <div class="col-sm-10">
                            <select name="group" class="form-control" id="selectGroup">
                                <option value="0">请选择分组</option>
                                <?php foreach ($groups as $g): ?>
                                    <option value="<?= $g['id'] ?>"><?= $g['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="email" class="col-sm-2 control-label">选择用户</label>

                        <div class="col-sm-10">
                            <select name="users[]" class="form-control" multiple id="selectUsers">
                                <?php foreach ($users as $u): ?>
                                    <option value="<?= $u['id'] ?>"><?= $u['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/dataTables.bootstrap.min.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/bootstrap-duallistbox.min.css"/>

<script src="<?= THEMEPATH ?>/js/jquery.bootstrap-duallistbox.min.js"></script>
<script src="<?= THEMEPATH ?>/js/jquery.dataTables.min.js"></script>
<script src="<?= THEMEPATH ?>/js/dataTables.bootstrap.min.js"></script>
<script src="<?= THEMEPATH ?>/js/validator.js"></script>

<script type="text/javascript">
    $(function () {
        var table = $('#groupTable').DataTable({
            language: {
                'url': '<?=THEMEPATH?>/js/dataTables.zh-CN.json'
            },
            "processing": true,
            "serverSide": true,
            'searching': false,
            "ajax": "<?= site_url('/admin/group/table/') ?>",
            "columns": [
                {"data": "id"},
                {"data": "name"},
                {"data": "action"}
            ]
        });

        $('#selectUsers').bootstrapDualListbox({
            'infoText': false,
            'infoTextEmpty': false,
            'selectorMinimalHeight': $(document).height() - 375
        });

        $('#selectGroup').change(function () {
            $("#selectUsers [selected]").attr('selected', false);
            var group = $(this).val();
            $.get('<?=site_url('admin/group/select')?>/' + group, function (data) {
                var group = $.parseJSON(data);
                var users = $.parseJSON(group.users);
                $.each(users, function (k, v) {
                    $("#selectUsers [value='" + v.id + "']").attr('selected', true);
                })
                $('#selectUsers').bootstrapDualListbox('refresh');
            });
        });

        $('#groupTable').on('click', '.editGroup', function () {
            var id = $(this).parents('tr').attr('id');
            ajax_dialog('编辑分组','<?=site_url('admin/group/add')?>/'+id,'m');
        });

        $('#groupTable').on('click', '.deleteGroup', function () {
            if (!confirm('确认删除此分组？')) return;
            var id = $(this).parents('tr').attr('id');
            $.get('<?=site_url('admin/group/delete')?>/'+id,function (data) {
                show_error(data);
            });
        });

        $('#selectForm').formValidator({
            sending: {
                type: 'ajax',
                success: function (data) {
                    show_error(data);
                },
                error: function () {
                    show_error('提交表单失败！');
                }
            }
        });
    });
</script>