<div class="maskLayer">
    <img src="<?= THEMEPATH ?>/images/loading.gif">
</div>

<div class="row">
    <div class="col-md-6">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h5>地区列表<span class="small">点击地区名称，在右侧编辑子节点。</span></h5>

            </div>
            <div class="panel-body">
                <div id="tree">
                    <div id="0">
                        <li>
                            <i class="fa fa-square"></i>
                            <span class="nodeName">根目录</span>
                        </li>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <form class="form-horizontal" action="<?= site_url('admin/city/edit') ?>" method="post" id="cityForm">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-md-8">
                            <h5>地区信息<span class="small">点击新建，将清空表单。</span></h5>
                        </div>
                        <div class="col-md-4 text-right">
                            <div class="btn-group">
                                <button class="btn btn-primary" type="submit" title="保存">
                                    <i class="fa fa-save"></i>
                                </button>
                                <button class="btn btn-info" type="button" id="createCity" title="新建">
                                    <i class="fa fa-plus"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">地区名称</label>

                        <div class="col-sm-10">
                            <input type="text" data-required="true" class="form-control" name="name" placeholder="NAME" value="">
                            <input type="hidden" name="id" value=""/>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="inputName" class="col-sm-2 control-label">上级地区</label>

                        <div class="col-sm-10">
                            <input type="hidden" name="parent" value="">
                            <input type="text" id="parentName" class="form-control" value="" placeholder="请从左侧选择地区">

                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>


<link rel="stylesheet" type="text/css" media="screen" href="<?= THEMEPATH ?>/css/jquery.jtree.css"/>

<script src="<?= THEMEPATH ?>/js/validator.js"></script>
<script src="<?= THEMEPATH ?>/js/jquery.jtree.js" type="text/javascript"></script>

<script type="text/javascript">
    $(function () {
        $('.maskLayer').height($(window).height() - 100);

        var node = <?=json_encode($cities, JSON_UNESCAPED_UNICODE)?>;
        $('#tree').jtree({
            data: node,
            nodeAction: function (id, text) {
                $('input[name=parent]').val(id);
                $('#parentName').val(text);
            },
            editAction: function (id) {

                $.get('<?=site_url('admin/city/select')?>/' + id, function (data) {
                    var city = $.parseJSON(data);
                    if (city.error) {
                        show_error(city.error);
                    } else {
                        $('input[name=name]').val(city.city.name);
                        $('input[name=id]').val(city.city.id);
                        $('input[name=parent]').val(city.parent.id);
                        $('#parentName').val(city.parent.name);
                        $('#selectParent').find('.active').removeClass('active');
                        $('#selectParent #' + city.parent.id).children('span').addClass('active');
                    }
                });
            },
            deleteAction: function (id) {
                if (!confirm('确认删除此地区？')) return false;

                if ($('#tree #' + id).find('li').length > 0) {
                    show_error('此科目下有子地区，请删除子地区后重试。');
                    return false;
                }
                $.get('<?=site_url('admin/city/delete/')?>/'+id,function(data) {
                    var e= $.parseJSON(data);
                    if (e.error) {
                        show_error(e.error);
                    } else {
                        show_error(e.success);
                        $('#selectParent').find('#'+id).remove();
                    }
                });
            }
        });

        $('#parentName').keydown(function () {
            $('#parentName').val('');
            alert('请从下方选择科目。');
        });


        $('#cityForm').formValidator({
            before: function () {
                var id = $(this).find('input[name=id]').val();
                var parent = $(this).find('input[name=parent]').val();

                if (id != 0 && parent != 0 && id == parent) {
                    show_error('地区的父节点不能是它自身。');
                    return false;
                }

                if (parent && $('#tree').find('li#' + id).find('li#' + parent).length > 0) {
                    show_error('地区的父节点不能是它的子节点。');
                    return false;
                }

            },
            sending: {
                type: 'ajax',
                success: function (data) {
                    show_error(data);
                    $('.main-content').load('<?=site_url('admin/city')?>');
                },
                error: function () {
                    show_error('提交表单失败！');
                }
            }
        });

        $('#createCity').click(function () {
            $('input').val('');
        });


        $('.maskLayer').remove();
    })
</script>