/**
 * Created by joe on 17-1-18.
 */

$.fn.jtree = function (options) {
    var obj = $(this);
    var option = $.extend({
        'data': {},
        'parentID': 'parent_id',
        'rootID': 0,
        'name': 'name',
        'id': 'id',
        'button': true, //是否显示节点按钮
        'select': false,
        'selectID': false,
        'close': true,
        'height': $(document).height() - 185,
        'ajax': {},
        'nodeAction': function () {
        },
        'editAction': function () {
        },
        'deleteAction': function () {
        },
    }, options || {});

    if (obj.find('#' + option.rootID).length == 0)
        obj.append($('<div>', {'id': option.rootID}));

    obj.find('#' + option.rootID).addClass('jtree').css('height', option.height);

    if (option.select == true)
        obj.find('#' + option.rootID).addClass('treeSelect');

    if (option.ajax.length > 0) {
        $.ajax({
            'url': option.ajax.url,
            'async': false,
            'cache': option.ajax.cache,
            'type': option.ajax.type ? option.ajax.type : 'get',
            'success': function (data) {
                console.log(data);
                option.data = $.parseJSON(data);
            }
        })
    }

    var data = option.data.sort(sortID);

    var nofind = [];
    create(data);
    if (nofind && nofind.length > 0) {
        create(nofind);
    }

    function create(data) {
        for (var node in data) {
            var parentNode = obj.find('#' + data[node][option.parentID]);

            if (parentNode.length != 0) {
                var nodeHtml = $('<li>', {'id': data[node][option.id]})
                    .append($('<i>', {'class': 'fa fa-square'}))
                    .append($('<span>', {'class': 'nodeName'}).html(data[node][option.name]));
                if (parentNode.find('ul').length == 0) {
                    parentNode.append($('<ul>'));
                    var icon = option.close ? 'fa-plus-square' : 'fa-minus-square';
                    parentNode.find('i').removeClass('fa-square').addClass(icon);
                    if (data[node][option.parentID] != option.rootID && option.close == true) parentNode.children('ul').hide();
                }
                parentNode.children('ul').append(nodeHtml);
            } else {
                nofind.push(data[node]);
            }
        }
    }

    if (option.selectID) {
        obj.find('#' + option.selectID).children('span').addClass('active');
    }

    obj.on('click', 'i.fa-plus-square,i.fa-minus-square', function () {
        var li = $(this).parent("li");
        li.children("ul").slideToggle();
        $(this).toggleClass("fa-plus-square fa-minus-square");
    });

    obj.on('click', 'li span', function () {
        var id = $(this).parent('li').attr('id');
        var text = $(this).text();
        option.nodeAction(id, text);
        if (option.select) {
            obj.find('.active').removeClass('active');
            $(this).addClass('active');
        }
    });

    if (option.button) {
        obj.on('mouseover', 'li span', function () {
            var li = $(this).parent('li');
            if (!li.attr('id')) return false;
            if (li.find('button').length < 1)
                $(this).after($('<button>', {'class': 'nodeBtn deleteTreeNode'})
                    .append($('<i>', {'class': "fa fa-trash"})))
                    .after($('<button>', {'class': 'nodeBtn editTreeNode'})
                        .append($('<i>', {'class': 'fa fa-edit'})));
        });

        obj.on('mouseleave', 'li', function () {
            $(this).find('button').remove();
        });

        obj.on('click', '.editTreeNode', function () {
            var li = $(this).parent('li');
            var id = li.attr('id');
            if (!id) {
                show_error('根目录不可编辑。');
                return false;
            }
            option.editAction(id);
        });

        obj.on('click', '.deleteTreeNode', function () {
            var li = $(this).parent('li');
            var id = li.attr('id');
            if (!id) {
                show_error('根目录不可编辑。');
                return false;
            }
            if (option.deleteAction(id) != false)
                li.remove();
        });
    }

    function sortID(a, b) {
        return a[option.parentID] - b[option.parentID]
    }


};