<?php

/**
 * Created by PhpStorm.
 * User: joe
 * Date: 17-2-6
 * Time: 上午8:55
 */
class Stat extends CI_Controller {

    public $user;

    function __construct() {
        parent::__construct();
        $this->load->model('users_model', 'users');
        $this->load->model('room_model', 'room');
        $this->user = $this->session->EXM_USER;
        if ($this->user['level'] != 9) {
            show_error('您没有权限访问此模块。', 200);
        }
    }

    function index($id) {
        $data['room'] = $id;
        $room         = $this->room->get($id, 'id,city');
        $city         = $room['city'] ? : 0;
        $sql          = "select * from city where FIND_IN_SET(id,getCityChild({$city}));";
        $cities       = $this->db->query($sql)->result_array();
        foreach ($cities as $c) {
            $data['cities'][] = $c['name'];
            $data['s100'][]   = $this->db->where('city', $c['id'])->where('score >', 100)->count_all_results('exam_page');
            $data['s80'][]    = $this->db->where('city', $c['id'])->where('score >=', 80)->where('score <=', 100)->count_all_results('exam_page');
            $data['s0'][]     = $this->db->where('city', $c['id'])->where('score <', 80)->count_all_results('exam_page');
        }
        $this->load->view('admin/stat', $data);
    }

    function table($id) {
        $search = $this->input->get_post('search');
        $this->load->library('Datatables');

        $action = <<<ETO
<div class="btn-group btn-group-sm">
    <a href="#"  class="btn btn-default viewTest" title="查看试卷">
        <i class="fa fa-eye"></i>
    </a>
</div>
ETO;

        if ($search['value']) {
            $this->datatables->like('users.name', $search['value']);
        }

        $this->datatables->select("exam_page.id,exam_page.score,users.name as user_name,city.name as city_name", false)
            ->from('exam_page')
            ->where('exam_page.room', $id)
            ->join('users', 'users.id = exam_page.user', 'left')
            ->join('city', 'city.id=users.city', 'left')
            ->add_column('DT_RowId', '$1', 'id')
            ->add_column('action', $action);

        echo $this->datatables->generate();
    }

    function get($id) {
        $s100=$this->input->post('100up');
        $s80=$this->input->post('80up');
        $room   = $this->room->get($id, 'id,city');
        $city   = $room['city'] ? : 0;
        $sql    = "select * from city where FIND_IN_SET(id,getCityChild({$city}));";
        $cities = $this->db->query($sql)->result_array();
        foreach ($cities as $c) {
            $data['s100'][] = $this->db->where('city', $c['id'])->where('score >', $s100)->count_all_results('exam_page');
            $data['s80'][]  = $this->db->where('city', $c['id'])->where('score >=', $s80)->where('score <=', $s100)->count_all_results('exam_page');
            $data['s0'][]   = $this->db->where('city', $c['id'])->where('score <', $s80)->count_all_results('exam_page');
        }
        show_json($data);
    }

}