<?php

/**
 * Created by PhpStorm.
 * User: joe
 * Date: 17-1-24
 * Time: 上午9:51
 */
class Room extends CI_Controller {

    public $user;

    function __construct() {
        parent::__construct();
        $this->load->model('users_model', 'users');
        $this->load->model('page_model', 'page');
        $this->load->model('room_model', 'room');
        $this->load->model('city_model', 'city');
        $this->load->model('group_model', 'group');
        $this->user = $this->session->EXM_USER;
        if ($this->user['level'] < 7) {
            show_error('您没有权限访问此模块。');
        }
    }

    function index() {
        $this->load->view('admin/room/list');
    }

    function table() {
        $search = $this->input->get_post('search');
        $this->load->library('Datatables');
        $checkbox = <<<ETO
<input type="checkbox" name="check" >
ETO;
        $action   = <<<ETO
<div class="btn-group btn-group-sm">
    <a href="#"  class="btn btn-default editRoom" title="编辑考场">
        <i class="fa fa-edit"></i>
    </a>
    <a href="#" class="btn btn-default deleteRoom" title="删除考场">
        <i class="fa fa-trash"></i>
    </a>
</div>
ETO;

        if ($search['value']) {
            $this->datatables->like('room.name', $search['value']);
        }

        $this->datatables->select("room.id,room.name,time,city.name as city_name,room.group,stat", false)
            ->from('room')
            ->join('city','city.id=room.city','left')
            ->add_column('DT_RowId', '$1', 'id')
            ->add_column('checkbox', $checkbox)
            ->add_column('action', $action);
        echo $this->datatables->generate();
    }

    function add($id = null) {

        $data['cities'] = $this->city->get();
        $data['groups'] = $this->group->get();
        $data['pages']  = $this->page->get('', 'id,name');
        if ($id) {
            $this->db->join('city','city.id=room.city','left');
            $data['room'] = $this->room->get('','room.*,city.name as city_name',['room.id'=>$id])[0];
        }
        $this->load->view('admin/room/add', $data);
    }

    function edit() {
        $room = [
            'id'   => $this->input->post('id'),
            'name' => $this->input->post('name'),
            'time' => $this->input->post('time'),
            'page' => $this->input->post('page'),
            'start'=> $this->input->post('start'),
            'stat' => $this->input->post('stat')
        ];

        $room['city'] = $this->input->post('city') ? : 0;

        $group = $this->input->post('group');

        if ($group[0]) {
            $groups        = $this->group->get(null, 'id,name', 'id in (' . implode(',', $group) . ')');
            $room['group'] = json_encode($groups, JSON_UNESCAPED_UNICODE);
        }

        $this->db->replace('room', $room);
        show_json(['success' => '保存成功。']);
    }

    function delete() {
        $id = $this->input->post_get('id');
        if (!$id) {
            show_json(['error' => '没有选择要删除的考场。']);
            return;
        }

        if (is_array($id)) {
            $this->db->where_in('id', $id);
        } else {
            $this->db->where('id', $id);
        }
        $this->db->where('room',$id)->delete('exam_page');
        if (is_array($id)) {
            $this->db->where_in('id', $id);
        } else {
            $this->db->where('id', $id);
        }
        $this->db->where('id',$id)->delete('room');
        show_json(['success' => '删除考场成功。']);
    }
}