<?php

/**
 * Created by PhpStorm.
 * User: joe
 * Date: 17-1-20
 * Time: 上午11:18
 */
class Question extends CI_Controller {

    public $user;

    function __construct() {
        parent::__construct();
        $this->load->model('users_model', 'users');
        $this->load->model('question_model', 'question');
        $this->load->model('category_model', 'category');
        $this->load->model('type_model', 'type');
        $this->user = $this->session->EXM_USER;
        if ($this->user['level'] != 9) {
            show_error('您没有权限访问此模块。');
        }
    }

    function index($id = null) {
        $this->load->view('admin/question/list');
    }

    function table() {
        $search = $this->input->get_post('search');
        $this->load->library('Datatables');
        $checkbox = <<<ETO
<input type="checkbox" name="check" >
ETO;
        $action   = <<<ETO
<div class="btn-group btn-group-sm">
    <a href="#"  class="btn btn-default editQuestion" title="编辑试题">
        <i class="fa fa-edit"></i>
    </a>
    <a href="#" class="btn btn-default deleteQuestion" title="删除试题">
        <i class="fa fa-trash"></i>
    </a>
</div>
ETO;

        if ($search['value']) {
            $this->datatables->like('question.name', $search['value']);
        }

        $this->datatables->select("question.id,question.name,category.name as category_name,types.name as type_name,question.date,level", false)
            ->from('question')
            ->join('types', 'types.id = question.type', 'left')
            ->join('category','category.id=question.category','left')
            ->add_column('DT_RowId', '$1', 'id')
            ->add_column('checkbox', $checkbox)
            ->add_column('action', $action);
        echo $this->datatables->generate();
    }

    function view($id) {
        if (!$id) {
            show_error('没有选择要查看的题目。');
        }
        $data['question'] = $this->question->get($id, 'question.*,types.name as type_name,category.name as category_name', null, true);
        $this->load->view('admin/question/view', $data);
    }

    function add($id = null) {
        $data['categories'] = $this->category->get();
        $data['types']      = $this->type->get();
        if ($id) {
            $data['question'] = $this->question->get($id);
            $data['category'] = $this->category->get($data['question']['category'], 'name');
        }
        $this->load->view('admin/question/add', $data);
    }

    function edit() {
        $option   = $this->input->post('option');
        $answer   = $this->input->post('answer');
        $question = [
            'id'       => $this->input->post('id'),
            'category' => $this->input->post('category'),
            'type'     => $this->input->post('type'),
            'name'     => $this->input->post('name'),
            'level'    => $this->input->post('level'),
            'analysis' => $this->input->post('analysis'),
            'date'     => date('Y-m-d')
        ];

        if (!$question['category']) {
            show_json(['error' => '您没有选择类别。']);
            return;
        }

        if (!strip_tags(trim($question['name']))) {
            show_json(['error' => '您没有输入题干。']);
            return;
        }

        if (in_array($question['type'], [1, 2, 3]) && !$answer) {
            show_json(['error' => '您没有选择答案。']);
            return;
        }

        $options = [];

        if (is_array($option) && is_array($answer)) {
            for ($i = 0; $i < count($option); $i++) {
                if (!$option[$i]) continue;
                $options[] = [
                    't' => $option[$i],
                    'a' => in_array($i, $answer) ? 't' : ''
                ];
            }
        } else {
            $options = $option;
        }

        $question['option'] = json_encode($options, JSON_UNESCAPED_UNICODE);

        $this->db->replace('question', $question);

        show_json(['success' => '保存成功。']);
    }

    function delete() {
        $id = $this->input->post_get('id');
        if (!$id) {
            show_json(['error' => '没有选择要删除的题目。']);
            return;
        }

        if (is_array($id)) {
            $this->db->where_in('id', $id);
        } else {
            $this->db->where('id', $id);
        }
        $this->db->delete('question');
        show_json(['success' => '删除题目成功。']);
    }

    function select($category, $type) {
        $sql = "select getCategoryChild({$category})";

        $categories = $this->db->query($sql)->row_array();

        $cate=explode(',',$categories["getCategoryChild({$category})"]);

        $sql = 'select id,name from question where category in ? and type = ?';

        $question = $this->db->query($sql, array($cate, $type))->result_array();

        $data['questions'] = $question;
        $data['type']      = $type;
        $data['category']  = $category;

        $this->load->view('admin/question/select', $data);
    }

}