<?php

/**
 * Created by PhpStorm.
 * User: joe
 * Date: 17-1-23
 * Time: 下午2:18
 */
class Page  extends CI_Controller {

    public $user;

    function __construct() {
        parent::__construct();
        $this->load->model('users_model', 'users');
        $this->load->model('page_model', 'page');
        $this->load->model('category_model', 'category');
        $this->user = $this->session->EXM_USER;
        if ($this->user['level'] < 7) {
            show_error('您没有权限访问此模块。');
        }
    }

    function index() {
        $this->load->view('admin/page/list');
    }

    function table() {
        $search = $this->input->get_post('search');
        $this->load->library('Datatables');
        $checkbox = <<<ETO
<input type="checkbox" name="check" >
ETO;
        $action   = <<<ETO
<div class="btn-group btn-group-sm">
    <a href="#"  class="btn btn-default editPage" title="编辑试卷">
        <i class="fa fa-edit"></i>
    </a>
    <a href="#" class="btn btn-default deletePage" title="删除试卷">
        <i class="fa fa-trash"></i>
    </a>
</div>
ETO;

        if ($search['value']) {
            $this->datatables->like('question.name', $search['value']);
        }

        $this->datatables->select("page.id,page.name,page.type,page.upset,category.name as category_name,date,users.name as user_name", false)
            ->from('page')
            ->join('category', 'category.id = page.category', 'left')
            ->join('users','users.id=page.user','left')
            ->add_column('DT_RowId', '$1', 'id')
            ->add_column('checkbox', $checkbox)
            ->add_column('action', $action);
        echo $this->datatables->generate();
    }

    function add($id=null) {
        $data['categories'] = $this->category->get();
        if ($id) {
            $data['page'] = $this->page->get($id);
            $data['category'] = $this->category->get($data['page']['category'], 'name');
        }
        $this->load->view('admin/page/add', $data);
    }

    function edit() {
        $page= [
            'id'=>$this->input->post('id')?:0,
            'name' => $this->input->post('name'),
            'category' => $this->input->post('category'),
            'type' => $this->input->post('type'),
            'time' => $this->input->post('time'),
            'total' => $this->input->post('total'),
            'passing' => $this->input->post('passing'),
            'upset' => $this->input->post('upset'),
            'date' => date('Y-m-d'),
            'user' => $this->user['id']
        ];
        $num=$this->input->post('num');
        $score=$this->input->post('score');
        if ($page['type']==1) $q=$this->input->post('ques');
        $question=[];
        foreach($num as $key=>$n) {
            if (!$n) continue;
            $question[$key+1]=['n'=>$n,'s'=>$score[$key]];
            if ($page['type']==1) $question[$key+1]['q']=$q[$key];
        }
        if (count($question) == 0) {
            show_json(['error'=>'没有进行选题。']);
            return;
        }
        $page['question']=json_encode($question);
        $this->db->replace('page',$page);
        show_json(['success'=>'保存成功']);
    }

    function delete() {
        $id = $this->input->post_get('id');
        if (!$id) {
            show_json(['error' => '没有选择要删除的试卷。']);
            return;
        }

        if (is_array($id)) {
            $this->db->where_in('id', $id);
        } else {
            $this->db->where('id', $id);
        }
        $this->db->delete('page');
        show_json(['success' => '删除试卷成功。']);
    }
}