<?php
/**
 * User: joe
 * Date: 17-1-22
 * Time: 下午5:16
 */
class Import extends CI_Controller {
	public $user;

	public function __construct() {
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('question_model', 'question');
		$this->load->model('category_model', 'category');
		$this->load->model('type_model', 'type');
		$this->user = $this->session->EXM_USER;
		if ($this->user['level'] < 7) {
			show_error('您没有权限访问此模块。');
		}
	}

	public function index() {
		$this->load->view('admin/question/import');
	}

	public function upload() {
		$config['upload_path'] = './upload/';
		$config['allowed_types'] = 'csv';
		$config['max_size'] = 10240;

		$this->load->library('upload', $config);

		if (!$this->upload->do_upload('file')) {
			show_json(['error' => $this->upload->display_errors()]);
		} else {
			$data = $this->upload->data();
			$this->parse($data["full_path"]);
		}
	}

	public function parse($file) {
		$csv = file($file);

		$i = 0;

		foreach ($csv as $line) {
			$option = [];
			$i++;
			if ($i == 1) {
				continue;
			}

			$q = explode(',', get_encoding($line));

			//试题类型
			if (preg_match("/^[0-9\s]+$/", strtoupper($q[9]))) {
				$type['id'] = $q[9];
			} else {
				$type = $this->db->select('id')->where('name', $q[9])->get('types')->row_array();
			}

			//试题分类
			if (preg_match("/^[0-9]+$/", strtoupper($q[0]))) {
				$category['id'] = $q[0];
			} else {
				$category = $this->db->select('id')->where('name', $q[0])->get('category')->row_array();
			}
			//试题选项
			for ($j = 2; $j <= 7; $j++) {
				if ($q[$j]) {
					$option[] = ['t' => $q[$j]];
				} else {
					if ($j == 2) {
						$option[] = ['t' => '正确'];
					} elseif ($j == 3) {
						$option[] = ['t' => '错误'];
					}

				}
			}

			//试题答案
			if (preg_match("/^[A-Z\s]+$/", strtoupper($q[8]))) {
				$answer = str_split(trim($q[8]));

				foreach ($answer as $a) {
					switch ($a) {
					case 'A':
					case 'T':
						$index = 0;
						break;
					case 'B':
						$index = 1;
						break;
					case 'C':
						$index = 2;
						break;
					case 'D':
						$index = 3;
						break;
					case 'E':
						$index = 4;
						break;
					case 'F':
						if ($type['id'] == 3) {
							$index = 1;
						} else {
							$index = 5;
						}
						break;
					}
					$option[$index]['a'] = 't';
				}
			}

			$question[] = [
				'id' => 0,
				'category' => $category['id'],
				'name' => $q[1],
				'type' => $type['id'],
				'level' => 0,
				'option' => json_encode($option, JSON_UNESCAPED_UNICODE),
				'analysis' => $q[10],
				'date' => date('Y-m-d'),
			];
		}

		$this->db->insert_batch('question', $question);
		unlink($file);
		if($this->db->error()) {
		    show_json($this->db->error());
       	 	} else {
	            show_json('导入成功,导入 ' . $i . ' 行数据。');
	        }
	}
}
