<?php

/**
 * Created by PhpStorm.
 * User: joe
 * Date: 17-1-17
 * Time: 下午2:28
 */
class User extends CI_Controller {

    public $user;

    function __construct() {
        parent::__construct();
        $this->load->model('users_model', 'users');
        $this->user = $this->session->EXM_USER;
    }

    function index() {

    }

    function avatar() {
        $config['upload_path']   = 'asset/images/avatar';
        $config['allowed_types'] = 'jpg|png|bmp|jpeg';
        $config['max_size']      = 100;
        $config['encrypt_name']  = true;


        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('imageUpload')) {
            show_error($this->upload->display_errors());
        } else {
            $data = array('upload_data' => $this->upload->data());

            $message = array(
                'path'    => $config['upload_path'],
                'profile' => $data['upload_data']
            );
            //删除原头像
            if ($this->user['avatar'] && $this->user['avatar'] != 'default.jpg' && file_exists('theme/images/avatar/' . $this->user['avatar'])) {
                unlink('asset/images/avatar/' . $this->user['avatar']);
            }
            $this->db->set('avatar', $data['upload_data']['file_name'])->where('id', $this->user['id'])->update('users');
            $this->user['avatar']    = $data['upload_data']['file_name'];
            $this->session->DMN_USER = $this->user;
            show_json($message);
        }
    }

    function modify() {
        $old_password    = $this->input->post_get('old_password');
        $new_password    = $this->input->post_get('new_password');
        $re_new_password = $this->input->post_get('re_new_password');

        if (!$old_password && !$new_password && !$re_new_password) {
            $this->load->view('modify');
        } else {

        }
    }

    function profile() {
        $data['user'] = $this->user;

        $data['province'] = $this->db->where('parent_id', 0)->get('city')->result_array();
        $data['city']     = $this->db->where('parent_id', substr($this->user['city'], 0, 2))->get('city')->result_array();
        $data['district'] = $this->db->where('parent_id', substr($this->user['city'], 0, 4))->get('city')->result_array();

        $this->load->view('profile', $data);
    }

}