<?php

/**
 * Created by PhpStorm.
 * User: joe
 * Date: 17-1-25
 * Time: 下午4:09
 */
class Test extends CI_Controller {

    public $user;

    function __construct() {
        parent::__construct();
        $this->load->model('users_model', 'users');
        $this->load->model('room_model', 'room');
        $this->load->model('page_model', 'page');
        $this->user = $this->session->EXM_USER;
        if (!$this->user) {
            show_error('您还没有登录，请返回<a href="' . site_url('/') . '">首页</a>登录后重试。');
        }
    }

    function index($id) {
        $room = $this->room->get($id, 'id,page,stat');
        $page = $this->page->get($room['page']);
        $sql = 'select t2.id from category t1, category t2 where t1.id=t2.parent_id and (t1.id= ? or t1.parent_id= ? ) union select t3.id from category t3 where t3.id= ? ';
        $categories = $this->db->query($sql, [
            $page['category'],
            $page['category'],
            $page['category']
        ])->result_array();

        foreach ($categories as $c) {
            $cate[] = $c['id'];
        }

        $sql = 'select `id`,`name`,`option` from question where category in ? and type = ? ORDER BY RAND()  LIMIT ?';
        foreach (json_decode($page['question'], true) as $k => $q) {
            $questions[$k] = $this->db->query($sql, [
                $cate,
                $k,
                (int)$q['n']
            ])->result_array();
        }
        if ($room['stat']==1) {
            $data['examPage'] = $this->db->select('id')->where([
                'user' => $this->user['id'],
                'room' => $id
            ])->get('exam_page')->row_array();
        }
        $data['user'] = $this->user;
        $data['page'] = $page;
        $data['room'] = $room;
        $data['questions'] = $questions;
        $this->load->view('test', $data);
    }

    function submit() {
        $id = $this->input->post('id');
        $answers = $this->input->post('answer');
        $exam = $this->db->where('id', $id)->get('exam_page')->row_array();

        $page = $this->page->get($exam['page']);
        $scores = json_decode($page['question'], true);

        $user_score = 0;
        $questions = json_decode($exam['question'], true);
        if (is_array($answers)) {
            foreach ($answers as $i => $answer) {
                $score = $scores[$i]['s'];
                foreach ($answer as $k => $a) {
                    if ($a == $questions[$i][$k]['a']) {
                        $user_score += $score;
                    }
                }
            }
        }

        $update = [
            'start_time' => $this->input->post('start'),
            'usetime'    => (int)$this->input->post('usetime'),
            'answer'     => json_encode($answers),
            'score'      => $user_score
        ];

        $this->db->where('id', $id)->update('exam_page', $update);

        show_json(['score' => $user_score]);
    }

    function view($id) {
        if (!$id) {
            show_error('没有找到您的考试记录。');
        }

        $data['page']=$this->db->where('id',$id)->get('exam_page')->row_array();
        if (!$data['page']) {
            show_error('没有找到您的考试记录。');
        }

        $this->load->view('view_test',$data);
    }

}