<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Main extends CI_Controller {

    public $user, $cityTree = [];

    function __construct() {
        parent::__construct();
        $this->load->model('users_model', 'users');
        $this->load->model('group_model', 'group');
        $this->load->model('city_model', 'city');
        $this->load->model('room_model', 'room');
        $this->load->model('page_model', 'page');
        $this->user = $this->session->EXM_USER;
    }

    public function index() {
        if (!$this->user) {
            redirect('login');
        }
        switch ($this->user['level']) {
            case '9':
                $data['user_title'] = '管理员';
                break;
            case '7':
                $data['user_title'] = '教师';
                break;
            default:
                $data['user_title'] = '普通用户';
                break;
        }
        $data['user'] = $this->user;
        $this->load->view('main', $data);
    }

    function show() {
        if ($this->user['level'] < 7) {
            $groups = $this->group->get(null, 'id', 'users like \'%"' . $this->user['id'] . '"%\'');

            $this->cityTree=$this->parentC($this->user['city']);
            if (count($this->cityTree) > 0) {
                $this->db->group_start();
                $this->db->where_in('room.city', $this->cityTree);

                $this->db->or_where('room.city', null);
                $this->db->group_end();
            }
            if ($groups) {
                $this->db->group_start();
                foreach ($groups as $group) {
                    $this->db->or_like('room.group', '"' . $group['id'] . '"');
                }
                $this->db->or_where('room.group', null);
                $this->db->group_end();
            }

            $this->db->join('exam_page', 'exam_page.room=room.id and exam_page.user=' . $this->user['id'], 'left');
            $this->db->join('city','city.id=room.city','left');
            $data['rooms'] = $this->db->select('room.id,room.name,room.time,city.name as city_name,room.stat,room.start,exam_page.score as score,exam_page.id as exam_page_id')
            ->get('room')->result_array();

            $userScore     = $this->db->select('score,start_time')->where('user', $this->user['id'])->get('exam_page')->result_array();
            $time          = [];
            $score         = [];
            foreach ($userScore as $s) {
                $time[]  = date('Y-m-d', strtotime($s['start_time']));
                $score[] = $s['score'];
            }
            $data['time']  = json_encode($time);
            $data['score'] = json_encode($score);
        } else {
            $this->db->join('city','city.id=room.city','left');
            $data['rooms'] = $this->room->get('','room.*,city.name as city_name');
        }

        $data['user'] = $this->user;
        $this->load->view('list', $data);
    }

    function parentC($id) {
        $sql="select getCityParent({$id})";
        $cities= $this->db->query($sql)->row_array();

        $city=explode(',',$cities["getCityParent({$id})"]);
        return array_unique($city);

    }

    function take($id) {
        $room = $this->room->get($id, 'id,name,page,stat');
        if ($room['stat'] == 0) {
            $p = $this->db->select('id')->where([
                'user' => $this->user['id'],
                'room' => $id
            ])->get('exam_page')->row_array();
            if ($p) {
                show_error('您已经参加过此场考试，不能重复。');
            }
        }

        $data['room'] = $room;
        $data['page'] = $this->page->get($data['room']['page'], 'time');

        $this->load->view('take', $data);
    }
}
